// ----------------------------------------------------------------------------------
// Microsoft Developer & Platform Evangelism
// 
// Copyright (c) Microsoft Corporation. All rights reserved.
// 
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
// ----------------------------------------------------------------------------------
// The example companies, organizations, products, domain names,
// e-mail addresses, logos, people, places, and events depicted
// herein are fictitious.  No association with any real company,
// organization, product, domain name, email address, logo, person,
// places, or events is intended or should be inferred.
// ----------------------------------------------------------------------------------

namespace SAMLNTService
{
    using System;
    using System.Configuration;
    using System.IdentityModel.Tokens;
    using System.Security.Cryptography.X509Certificates;
    using System.ServiceModel;
    using System.ServiceModel.Web;
    using Microsoft.IdentityModel.Configuration;
    using Microsoft.IdentityModel.Protocols.WSTrust;
    using Microsoft.IdentityModel.Protocols.WSTrust.Bindings;
    using Microsoft.IdentityModel.SecurityTokenService;
    using Microsoft.IdentityModel.Tokens;
    using SimpleActiveSTS;

    public static class Program
    {
        public static void Main()
        {
            string signingCertName = ConfigurationManager.AppSettings["signingCertName"];
            string baseAddress = ConfigurationManager.AppSettings["stsBaseAddress"];
            string stsPath = ConfigurationManager.AppSettings["stsPath"];
            string acsHostName = ConfigurationManager.AppSettings["acsHostName"];

            string stsUri = string.Format("https://{0}/{1}", baseAddress, stsPath);

            SigningCredentials signingCreds = new X509SigningCredentials(CertificateUtil.GetCertificate(StoreName.My, StoreLocation.LocalMachine, signingCertName));
            SecurityTokenServiceConfiguration config = new SecurityTokenServiceConfiguration(stsUri, signingCreds);

            WindowsWSTrustBinding binding = new WindowsWSTrustBinding(SecurityMode.TransportWithMessageCredential);
            config.TrustEndpoints.Add(new ServiceHostEndpointConfiguration(typeof(IWSTrust13SyncContract), binding, stsPath));
            config.SecurityTokenService = typeof(WindowsSecurityTokenService);
            WSTrustServiceHost host = new WSTrustServiceHost(config, new Uri(string.Format("https://{0}", baseAddress)));
            host.Description.Behaviors.Add(new ConfigureServiceHostServiceBehavior());
            host.Open();

            // Fed endpoint at https://localhost/localsts/FederationMetadata/2007-06/FederationMetadata.xml
            WebHttpBinding fedBinding = new WebHttpBinding(WebHttpSecurityMode.Transport);
            WebServiceHost fedHost = new WebServiceHost(typeof(FedMetadataService), new Uri(string.Format("https://{0}", baseAddress)));
            fedHost.AddServiceEndpoint(typeof(IFederationMetadataService), fedBinding, "FederationMetadata/2007-06");
            fedHost.Open();

            Console.WriteLine("STS is listening");
            Console.WriteLine("Token issuing endpoint: {0}", stsUri);
            Console.WriteLine("Fed Metadata endpoint: {0}", string.Format("https://{0}/FederationMetadata/2007-06/FederationMetadata.xml", baseAddress));
            Console.ReadLine();

            host.Close();
            fedHost.Close();
        }
    }
}